#define MMAX 13
#define NMAX 13
#define EPS 1e-6
#define DLUGOSC 40
#define rozmiar 44

#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <stdlib.h>
#include <stdarg.h>
#include "wprowadz.h"

float R;
float A[MMAX][NMAX], KOPIA[MMAX][NMAX];
int  IPOSV[MMAX], IZROV[NMAX];
int  i,j,ICASE,N,M=-1,M1,M2,M3;


void kopiuj(float A[][NMAX], float B[][NMAX]) //kopiuje macierz A dla funkcji wykreslajacej
{
	int i,j;
	for(i=0; i<NMAX-1; i++)
	for(j=0; j<MMAX-1; j++)
		B[i][j]=A[i+1][j+1];
}

void tablsimplx() //wyswietlanie tablicy symplexowej
{
	printf("\n >< |   Bi   |");
	for (i=1; i<=N; i++) {
	if(IZROV[i]<=N) printf("|   X%d   ",IZROV[i]);
	else printf("|   Y%d   ",IZROV[i]-N);
	if(i==N)printf("|\n");
	}

	printf("----+--------+");
	for (i=1; i<=N; i++) {
	printf ("+--------");
	if(i==N)printf("+\n");
	}

	printf(" Z  ");
	for (j=1; j<=N+1; j++) {
		printf("|%8.2f", A[1][j]); if(j==N+1||j==1) printf("|");
	}
	printf("\n");
	for(i=2;i<=M+1;i++) {

		if(IPOSV[i-1]<=N) printf(" X%d ",IPOSV[i-1]);
		else printf(" Y%d ",IPOSV[i-1]-N);

		for (j=1; j<=N+1; j++) {
			printf("|%8.2f", A[i][j]); if(j==N+1||j==1) printf("|");
		}
	printf("\n");
	}
		printf("----+--------+");
	for (i=1; i<=N; i++) {
	printf ("+--------");
	if(i==N)printf("+\n");
	}

	getch();
}

void simp1(float a[][NMAX], int mm, int ll[], int nll,
	int iabf, int *kp, float *bmax)  //szuka max elementu z wektora
{                                        //indexowanego przez ll
	int k;
	float test;

	if (nll <= 0)
		*bmax=0.0;
	else {
		*kp=ll[1];
		*bmax=a[mm+1][*kp+1];
		for (k=2;k<=nll;k++) {
			if (iabf == 0)
				test=a[mm+1][ll[k]+1]-(*bmax);
			else
				test=fabs(a[mm+1][ll[k]+1])-fabs(*bmax);
			if (test > 0.0) {
				*bmax=a[mm+1][ll[k]+1];
				*kp=ll[k];
			}
		}
	}
}


void simp2(float a[][NMAX], int m, int n, int *ip, int kp)
{                             //szuka elementu do piwotyzacji
	int k,i;
	float qp,q0,q,q1;

	*ip=0;
	for (i=1;i<=m;i++)
		if (a[i+1][kp+1] < -EPS) break;
	if (i>m) return;
	q1 = -a[i+1][1]/a[i+1][kp+1];
	*ip=i;
	for (i=*ip+1;i<=m;i++) {
		if (a[i+1][kp+1] < -EPS) {
			q = -a[i+1][1]/a[i+1][kp+1];
			if (q < q1) {
				*ip=i;
				q1=q;
			} else if (q == q1) {  //!!! tutaj mamy degeneracje
				for (k=1;k<=n;k++) {
					qp = -a[*ip+1][k+1]/a[*ip+1][kp+1];
					q0 = -a[i+1][k+1]/a[i+1][kp+1];
					if (q0 != qp) break;
				}
				if (q0 < qp) *ip=i;
			}
		}
	}
}

simp3(float a[][NMAX], int i1, int k1, int ip, int kp)
{                              //zamienia wiersz i kolumne ze soba
	int ii,kk;
	float piv;

	piv=1.0/a[ip+1][kp+1];
	for (ii=1;ii<=i1+1;ii++)
		if (ii-1 != ip) {
			a[ii][kp+1] *= piv;
			for (kk=1;kk<=k1+1;kk++)
				if (kk-1 != kp)
					a[ii][kk] -= a[ip+1][kk]*a[ii][kp+1];
		}
	for (kk=1;kk<=k1+1;kk++)
		if (kk-1 != kp) a[ip+1][kk] *= -piv;
	a[ip+1][kp+1]=piv;
}

void simplx(float a[][NMAX], int m, int n, int m1, int m2, int m3, int *icase, int izrov[], int iposv[])
{       //glowna funkcja algorytmu simplex

	int i,ip,is,k,kh,kp,nl1;
	int *l1, *l3;
	float q1,bmax;
	nl1=n;
	for (k=1;k<=n;k++) l1[k]=izrov[k]=k;
	for (i=1; i<=m; i++) {
	  if (a[i+1][1] < 0.0) {
			printf(" Jedna ze staych jest niedodatnia!.\n");
		return;
	  }
		iposv[i]=n+i;
	}
	if (m2+m3) {
		for (i=1;i<=m2;i++) l3[i]=1;
		for (k=1;k<=(n+1);k++) {
			q1=0.0;
			for (i=m1+1;i<=m;i++) q1 += a[i+1][k];
			a[m+2][k] = -q1;
		}
		for (;;) {
			simp1(a,m+1,l1,nl1,0,&kp,&bmax);
			if (bmax <= EPS && a[m+2][1] < -EPS) {
				*icase = -1;  //brak rozwiazan
				return;
			} else if (bmax <= EPS && a[m+2][1] <= EPS) {
				for (ip=m1+m2+1;ip<=m;ip++) {
					if (iposv[ip] == (ip+n)) {
						simp1(a,ip,l1,nl1,1,&kp,&bmax);
						if (bmax > EPS) goto one;
					}
				}
				for (i=m1+1;i<=m1+m2;i++)
					if (l3[i-m1] == 1)
						for (k=1;k<=n+1;k++)
							a[i+1][k]= -a[i+1][k];
				break; //i do fazy 2
			}
			simp2(a,m,n,&ip,kp);
			if (ip == 0) {
				*icase = -1;
				return;
			}
	one:	simp3(a,m+1,n,ip,kp);
			if (iposv[ip] >= (n+m1+m2+1)) {
				for (k=1;k<=nl1;k++)
					if (l1[k] == kp) break;
				--nl1;
				for (is=k;is<=nl1;is++) l1[is]=l1[is+1];
			} else {
				kh=iposv[ip]-m1-n;
				if (kh >= 1 && l3[kh]) {
					l3[kh]=0;
					++a[m+2][kp+1];
					for (i=1;i<=m+2;i++)
						a[i][kp+1]= -a[i][kp+1];
				}
			}
			is=izrov[kp];
			izrov[kp]=iposv[ip];
			iposv[ip]=is;
			tablsimplx(); //tu wyswietlamy
		}
	}
/***************** koniec fazy 1 !!! ***************************************/
	for (;;) {
		simp1(a,0,l1,nl1,0,&kp,&bmax);
		if (bmax <= EPS) {
			*icase=0;    //no i bomba :)
			return;
		}
		simp2(a,m,n,&ip,kp);
		if (ip == 0) {
			*icase=1;    //nieograniczona funkcja
			return;
		}
		simp3(a,m,n,ip,kp);
		is=izrov[kp];
		izrov[kp]=iposv[ip];
		iposv[ip]=is;
		tablsimplx();     //i znow wyswietlamy
	}
}

/*********************          MAIN            *************************/
/************************************************************************/

void main() {
  int dane, i, min=0;
  float pnk_optymX1=-1, pnk_optymX2=-1;
  struct komorka baz;
  _wscroll=0;

  do
	{
		dane=opcje();
		switch (dane)
		{
			case 1:
				// wprowadz dane;
				pnk_optymX1=pnk_optymX2=-1;
				M1=M2=M3=N=-1;
				wprowadz(A, M1, M2, M3, N, min);
				kopiuj(A,KOPIA);
				M=M1+M2+M3;
				for (i=1; i<=N; i++) IZROV[i]=i;
				for (i=1; i<=M; i++) IPOSV[i]=N+i;
				break;
			case 2:
				//wyswietl kolejne kroki algorytmu
				//printf("2");
				clrscr();
				printf("\n Dane poczatkowe:\n");
				tablsimplx();

				simplx(A,M,N,M1,M2,M3,&ICASE,IZROV,IPOSV);

				if (ICASE==0) {  // ok.
					printf("\n Dane wynikowe:\n");
					tablsimplx();
						for (i=2;i<=N+1;i++) if(A[1][i]==0) {
								printf("funkcja ma nieskonczenie wiel rozwiazan.\nPrzykladowe rozwiazanie:\n");
								break;
									 }
					if (min==1) {
						A[1][1]=-A[1][1];
						printf("\n Minimum funkcji wyjscia max(z) = %f\n", A[1][1]);
					}
					else printf("\n Maximum funkcji wyjscia max(z) = %f\n", A[1][1]);

					for (i=1; i<=N; i++) {
								for (j=1; j<=M; j++)
								if (IPOSV[j] == i)  {
								printf("  X%d = %f\n", i, A[j+1][1]);
								if (i==1) pnk_optymX1=A[j+1][1];
								if (i==2) pnk_optymX2=A[j+1][1];
								goto e;
								}
					printf("  X%d = %f\n", i, 0.0);
					if (i==1) pnk_optymX1=0.0;
					if (i==2) pnk_optymX2=0.0;
				e:;}
				}
				if(ICASE==1) printf("\nZbior jest nieograniczony!!!\n");
				if(ICASE==-1) printf("\nZadanie nie ma rozwizania!!!\n");
				getch();
				break;
			case 3:
				//wyswietl wynik
				clrscr();
				if (ICASE==0) {  // ok.
					printf("\n Dane wynikowe:\n");
					tablsimplx();
						for (i=2;i<=N+1;i++) if(A[1][i]==0) {
								printf("funkcja ma nieskonczenie wiel rozwiazan.\nPrzykladowe rozwiazanie:\n");
								break;
									 }
					if (min==1) {
						A[1][1]=-A[1][1];
						printf("\n Minimum funkcji wyjscia max(z) = %f\n", A[1][1]);
					}
					else printf("\n Maximum funkcji wyjscia max(z) = %f\n", A[1][1]);

					for (i=1; i<=N; i++) {
								for (j=1; j<=M; j++)
								if (IPOSV[j] == i)  {
								printf("  X%d = %f\n", i, A[j+1][1]);
								if (i==1) pnk_optymX1=A[j+1][1];
								if (i==2) pnk_optymX2=A[j+1][1];
								goto e2;
								}
					printf("  X%d = %f\n", i, 0.0);
					if (i==1) pnk_optymX1=0.0;
					if (i==2) pnk_optymX2=0.0;
				e2:;}
				}
				if(ICASE==1) printf("\nZbior jest nieograniczony!!!\n");
				if(ICASE==-1) printf("\nZadanie nie ma rozwizania!!!\n");
				getch();
				break;

			case 4:
				if(M>0 && pnk_optymX1!=-1 && ICASE==0)
					rysuj_wykres(KOPIA, N, M, M1, M2, M3,pnk_optymX1, pnk_optymX2);
				else{
					clrscr();
					printf("\n\n\t\tLiczba ograniczen M musi byc wieksza od zera.\n");
					printf("\t      Wprowadz dane do obliczen i wybierz punkt 2 lub 3.\n\n\n");
					printf("\t\t           Nacisnij dowolny znak.");
					getch();
					clrscr();
				}
				break;
			case 5:
				//koniec programu
			default:
				if (quit()==1)
					exit(0);
				dane=1;
				break;
		};
	}
	while(dane);
}